<?php
include 'conexao.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $aluno_id = intval($_POST['aluno_id'] ?? 0);
    $turma_id = intval($_POST['turma_id'] ?? 0);

    if ($aluno_id > 0 && $turma_id > 0) {
        // Verifica se já existe votação
        $check = $conn->prepare("SELECT 1 FROM votacoes WHERE aluno_id = ? AND turma_id = ?");
        $check->bind_param("ii", $aluno_id, $turma_id);
        $check->execute();
        $result = $check->get_result();

        if ($result->num_rows === 0) {
            // Inserir nova votação
            $insert = $conn->prepare("INSERT INTO votacoes (aluno_id, turma_id) VALUES (?, ?)");
            $insert->bind_param("ii", $aluno_id, $turma_id);
            if ($insert->execute()) {
                echo "ok";
            } else {
                echo "erro ao salvar votação";
            }
        } else {
            echo "ok"; // Já existe, não precisa duplicar
        }
    } else {
        echo "dados inválidos";
    }
} else {
    echo "método inválido";
}
